define(function () {

    var component = {
        inject: ["configuration"],
        data: function () {
            return {
                showMoreNewsToggle: true
            };
        },
        methods: {
            showMoreNews: function () {
                var _this = this;
                this.getItems(parseInt(this.webpartProperties.moreNews) +
                    parseInt(this.webpartProperties.numberOfNews)).then(function () {
                    _this.showMoreNewsToggle = !_this.showMoreNewsToggle;
                });
            },
            showLessNews: function () {
                var _this = this;
                this.getItems(this.webpartProperties.numberOfNews).then(function () {
                    _this.showMoreNewsToggle = !_this.showMoreNewsToggle;
                });
            }
        }
    };

    component.originalTemplate = "corpViewModern.list";
    component.template = `
<wizdomWebpart data-v-1c131c88
  :environmentInfo="environmentInfo"
  :chromeProperties="webpartProperties.chromeProperties"
  :title="'Corporate News' | translate"
  @titleChanged="webpartProperties.title = $event"
  :webpartPadding="true"
  chromeType="title"
  @webpart-resize="webpartResize"
>
  <div data-v-1c131c88 v-if="items.length > 0">
    <div data-v-1c131c88>
      <div data-v-1c131c88 class="news-items ms-Grid revert-Padding">
        <div data-v-1c131c88
          :class="'news-item-wrapper flex ms-Grid-row columnStyle' + webpartProperties.numberPerPage"
          v-for="item in items"
          :key="item.date"
          v-bind:style="'width: calc('+ (100/webpartProperties.numberPerPage) +'% - 16px)'"
        >
          <div data-v-1c131c88 class="news-item ms-Grid-col ms-md12">
            <div data-v-1c131c88 class="ms-Grid-row row-container">
              <div data-v-1c131c88 class="imageContainer ms-Grid-col ms-md6 ms-sm12">
                <a data-v-1c131c88 :href="item.path" target="_blank" class="image-link">
                  <div data-v-1c131c88 class="image-image">
                    <div data-v-1c131c88 class="image-image imageContainer" :style="getStyle(item)">
                      <div data-v-1c131c88
                        v-if="item.breaking && webpartProperties.breakingTag"
                        class="breaking"
                      >{{webpartProperties.breakingTagText}}</div>
                    </div>
                  </div>
                </a>
              </div>
              <div data-v-1c131c88
                :class="'content columnStyle' + webpartProperties.numberPerPage + '-content ms-Grid-col ms-md6 ms-sm12'"
              >
                <a data-v-1c131c88 :href="item.path" target="_blank" class="text-link">
                  <div data-v-1c131c88 v-if="webpartProperties.numberPerPage === 1">
                    <h2 data-v-1c131c88 class="title">{{item.title}}</h2>
                    <p data-v-1c131c88
                      v-if="item.summary.length !== 0"
                      class="content-text"
                      v-html="item.summary"
                    ></p>
                    <p data-v-1c131c88 v-else class="content-text" v-html="item.content"></p>
                  </div>
                  <div data-v-1c131c88 v-if="webpartProperties.numberPerPage === 2">
                    <h2 data-v-1c131c88 class="title">{{item.title}}</h2>
                    <p data-v-1c131c88
                      v-if="item.summary.length !== 0"
                      class="content-text"
                      v-html="item.summary"
                    ></p>
                    <p data-v-1c131c88 v-else class="content-text" v-html="item.content"></p>
                  </div>
                  <div data-v-1c131c88 class="timeago-and-author">
                    <span data-v-1c131c88 class="author">{{item.author}}</span>
                    <div data-v-1c131c88 class="timeago-views-container">
                      <span data-v-1c131c88 v-show="item.date" class="timeago">
                        <uiIconClock data-v-1c131c88 />
                        <timeago data-v-1c131c88 :since="item.date" locale="lang">></timeago>
                      </span>
                    </div>
                    <views data-v-1c131c88 v-if="webpartProperties.showViewCount" :views="item.views" class="views"></views>
                  </div>
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div data-v-1c131c88 v-if="webpartProperties.moreNews > 0" class="show-more pointer">
      <span data-v-1c131c88 v-if="showMoreNewsToggle" @click="showMoreNews()">
        {{'Show more'| translate}}
        <uiIconChevronDownMed data-v-1c131c88 class="show-more-icon" />
      </span>
      <span data-v-1c131c88 v-else @click="showLessNews()">
        {{'Show less'| translate}}
        <uiIconChevronUpMed data-v-1c131c88 class="show-more-icon" />
      </span>
    </div>
  </div>
</wizdomWebpart>
`;
    component.styles = `
.columnStyle1[data-v-1c131c88] {
  display: flex;
  flex: 2;
  min-width: 170px;
  flex-basis: 100%;
}
.columnStyle2[data-v-1c131c88] {
  display: flex;
  flex: 2;
  min-width: 350px;
  flex-basis: 50%;
}
.pointer[data-v-1c131c88] {
  cursor: pointer;
}
.columnStyle2-content[data-v-1c131c88] {
  display: flex;
  flex-direction: column;
  max-width: 100%;
  overflow: hidden;
  color: "[theme:bodyText, default: #333]";
  flex: 2;
  max-height: 140px;
  flex-basis: 75%;
}
.row-container[data-v-1c131c88] {
  display: flex;
  width: 100%;
  flex-wrap: wrap;
  flex-direction: row;
}
.breaking[data-v-1c131c88] {
  color: "[theme:white, default:#fff]";
  background-color: "[theme:accent, default:#0078d4]";
  position: absolute;
  top: 20px;
  left: 0;
  z-index: 1;
  text-align: center;
  padding: 5px 10px 5px 10px;
}
.flex[data-v-1c131c88] {
  flex-wrap: wrap;
}
.news-items[data-v-1c131c88] {
  -ms-flex-flow: row wrap;
  flex-flow: row wrap;
  -ms-flex-pack: justify;
  display: -ms-flexbox;
  display: flex;
}
.news-items .news-item-wrapper[data-v-1c131c88] {
    padding-bottom: 20px;
    padding-top: 20px;
    border-bottom: 1px solid "[theme:neutralLight, default:#eaeaea]";
    color: "[theme:bodyText, default: #333]";
}
@media (min-width: 880px) {
.CanvasSection-xl12 .news-items .news-item-wrapper.columnStyle2[data-v-1c131c88]:nth-last-of-type(-n + 2) {
        border-bottom: 0px solid "[theme:neutralLight, default:#eaeaea]";
}
}
.news-items .news-item-wrapper[data-v-1c131c88]:last-of-type {
      border-bottom: 0px solid "[theme:neutralLight, default:#eaeaea]";
}
.news-items .news-item-wrapper[data-v-1c131c88]:first-of-type {
      padding-top: 0;
}
.CanvasSection-xl12 .news-items .news-item-wrapper.columnStyle2[data-v-1c131c88]:nth-child(-n + 2) {
      padding-top: 0;
}
.news-items .news-item-wrapper .news-item[data-v-1c131c88] {
      padding-left: 0;
      padding-right: 0;
      display: flex;
      flex-wrap: wrap;
      flex-direction: row;
      display: -ms-flexbox;
      display: flex;
      height: 100%;
      box-sizing: border-box;
      position: relative;
      color: "[theme:bodyText, default: #333]";
}
.news-items .news-item-wrapper .news-item .imageContainer[data-v-1c131c88] {
        flex: none;
        align-self: flex-start;
        box-sizing: border-box;
        -ms-flex-negative: 0;
        flex-shrink: 0;
        margin-bottom: 5px;
        height: 100%;
}
.news-items .news-item-wrapper .news-item .imageContainer .image-link[data-v-1c131c88] {
          text-decoration: none;
}
.news-items .news-item-wrapper .news-item .imageContainer .image-link .image-image[data-v-1c131c88] {
            height: 100%;
            width: 100%;
            position: relative;
}
.news-items .news-item-wrapper .news-item .imageContainer .image-link .image-image img[data-v-1c131c88] {
              display: block;
              opacity: 1;
              width: 100%;
              height: auto;
              position: absolute;
              left: 50%;
              top: 50%;
              transform: translate(-50%, -50%);
}
.news-items .news-item-wrapper .news-item .content[data-v-1c131c88] {
        display: -ms-flexbox;
        display: flex;
        -ms-flex-preferred-size: 0;
        flex-basis: 0;
        -ms-flex-direction: column;
        flex-direction: column;
        -ms-flex-positive: 1;
        flex-grow: 1;
        -ms-flex-pack: justify;
        max-width: 100%;
        overflow: hidden;
        color: "[theme:bodyText, default: #333]";
        max-height: 200px;
}
.news-items .news-item-wrapper .news-item .content h2[data-v-1c131c88] {
          margin: 0;
          font-size: 21px;
}
.news-items .news-item-wrapper .news-item .content h2.title[data-v-1c131c88] {
            margin-left: -1px;
            text-overflow: ellipsis;
            overflow: hidden;
            white-space: nowrap;
            margin-top: 0;
            display: block;
            font-weight: normal;
            line-height: 1.3;
}
.news-items .news-item-wrapper .news-item .content .content-text[data-v-1c131c88] {
          font-size: 14px;
          margin-top: 5px;
          line-height: 1.3em;
          height: 4em;
          overflow: hidden;
}
a[data-v-1c131c88] {
  text-decoration: none;
}
.text-link[data-v-1c131c88] {
  color: "[theme:bodyText, default: #333]";
}
.like-and-comment .like-container[data-v-1c131c88],
.like-and-comment .comment-container[data-v-1c131c88] {
  top: 2px;
}
.like-and-comment .like-container .icon[data-v-1c131c88],
  .like-and-comment .comment-container .icon[data-v-1c131c88] {
    vertical-align: sub;
}
.like-and-comment .like-container .counter[data-v-1c131c88],
  .like-and-comment .comment-container .counter[data-v-1c131c88] {
    margin-left: 5px;
    margin-right: 10px;
}
.timeago[data-v-1c131c88] {
  padding-right: 5px;
}
.timeago-and-author[data-v-1c131c88] {
  display: flex;
  flex-direction: row;
  flex-wrap: wrap;
  margin-top: 5px;
  font-size: 12px;
}
.timeago-and-author .author[data-v-1c131c88] {
    font-weight: 900;
    margin-right: 5px;
}
.views[data-v-1c131c88] {
  font-size: 12px;
}
.show-more[data-v-1c131c88] {
  padding-right: 16px;
  padding-bottom: 10px;
  color: "[theme:bodyText, default: #333]";
  float: right;
}
.show-more .show-more-icon[data-v-1c131c88] {
    vertical-align: sub;
}
@media (max-width: 433px) {
.columnStyle2[data-v-1c131c88] {
    display: flex;
    flex: 2;
    min-width: 170px;
    flex-basis: 100%;
}
.show-more[data-v-1c131c88] {
    padding-right: none;
    float: none;
    position: relative;
    bottom: -90px;
    text-align: center;
}
.news-items[data-v-1c131c88] {
    -ms-flex-flow: row wrap;
    flex-flow: row wrap;
    -ms-flex-pack: justify;
    display: -ms-flexbox;
    display: flex;
}
.news-items .news-item-wrapper[data-v-1c131c88] {
      padding: 90px 0;
      color: "[theme:bodyText, default: #333]";
}
.news-items .news-item-wrapper .news-item .content h2[data-v-1c131c88] {
        margin: 0;
        font-size: 21px;
}
.news-items .news-item-wrapper .news-item .content h2.title[data-v-1c131c88] {
          margin-left: -1px;
          text-overflow: unset !important;
          overflow: hidden;
          white-space: normal !important;
          margin-top: 0;
          display: block;
          font-weight: normal;
          line-height: 1.3;
}
}


`;

    return component;

});
